using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using ZylGPSReceiver;

namespace CSharpDemo
{	
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class Form1 : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Button btnOpen;
		private System.Windows.Forms.Button btnClose;	
		private System.Windows.Forms.ListBox lstPorts;

		private System.Windows.Forms.TextBox textBoxOut;
		private System.Windows.Forms.GroupBox groupBox3;
		private System.Windows.Forms.Label label12;
		private System.Windows.Forms.Label label11;
		private System.Windows.Forms.Label label10;
		private System.Windows.Forms.Label label9;
		private System.Windows.Forms.TextBox textBoxSatCount;
		private System.Windows.Forms.TextBox textBoxHeading;
		private System.Windows.Forms.TextBox textBoxSpeed;
		private System.Windows.Forms.TextBox textBoxAlt;
		private System.Windows.Forms.GroupBox groupBox2;
		private System.Windows.Forms.Label label8;
		private System.Windows.Forms.Label label7;
		private System.Windows.Forms.Label label6;
		private System.Windows.Forms.Label label5;
		private System.Windows.Forms.TextBox textBoxLongDir;
		private System.Windows.Forms.TextBox textBoxLongSec;
		private System.Windows.Forms.TextBox textBoxLongMin;
		private System.Windows.Forms.TextBox textBoxLongDeg;
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.Label label4;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.TextBox textBoxLatDir;
		private System.Windows.Forms.TextBox textBoxLatSec;
		private System.Windows.Forms.TextBox textBoxLatMin;
		private System.Windows.Forms.TextBox textBoxLatDeg;
		private ZylGPSReceiver.GPSReceiver gpsReceiver;
		private System.Windows.Forms.Label label14;
		private System.Windows.Forms.Label label13;
		private System.Windows.Forms.Label lblLocalTime;
		private System.Windows.Forms.Label lblUTCTime;
		private System.ComponentModel.IContainer components;

        // This delegate enables asynchronous calls for setting
        // the text property on a TextBox control.
        delegate void SetTextCallback(string text);

		public Form1()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();
			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			this.textBoxOut = new System.Windows.Forms.TextBox();
			this.lstPorts = new System.Windows.Forms.ListBox();
			this.btnOpen = new System.Windows.Forms.Button();
			this.btnClose = new System.Windows.Forms.Button();
			this.groupBox3 = new System.Windows.Forms.GroupBox();
			this.label12 = new System.Windows.Forms.Label();
			this.label11 = new System.Windows.Forms.Label();
			this.label10 = new System.Windows.Forms.Label();
			this.label9 = new System.Windows.Forms.Label();
			this.textBoxSatCount = new System.Windows.Forms.TextBox();
			this.textBoxHeading = new System.Windows.Forms.TextBox();
			this.textBoxSpeed = new System.Windows.Forms.TextBox();
			this.textBoxAlt = new System.Windows.Forms.TextBox();
			this.groupBox2 = new System.Windows.Forms.GroupBox();
			this.label8 = new System.Windows.Forms.Label();
			this.label7 = new System.Windows.Forms.Label();
			this.label6 = new System.Windows.Forms.Label();
			this.label5 = new System.Windows.Forms.Label();
			this.textBoxLongDir = new System.Windows.Forms.TextBox();
			this.textBoxLongSec = new System.Windows.Forms.TextBox();
			this.textBoxLongMin = new System.Windows.Forms.TextBox();
			this.textBoxLongDeg = new System.Windows.Forms.TextBox();
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.label4 = new System.Windows.Forms.Label();
			this.label3 = new System.Windows.Forms.Label();
			this.label2 = new System.Windows.Forms.Label();
			this.label1 = new System.Windows.Forms.Label();
			this.textBoxLatDir = new System.Windows.Forms.TextBox();
			this.textBoxLatSec = new System.Windows.Forms.TextBox();
			this.textBoxLatMin = new System.Windows.Forms.TextBox();
			this.textBoxLatDeg = new System.Windows.Forms.TextBox();
			this.gpsReceiver = new ZylGPSReceiver.GPSReceiver(this.components);
			this.label14 = new System.Windows.Forms.Label();
			this.label13 = new System.Windows.Forms.Label();
			this.lblLocalTime = new System.Windows.Forms.Label();
			this.lblUTCTime = new System.Windows.Forms.Label();
			this.groupBox3.SuspendLayout();
			this.groupBox2.SuspendLayout();
			this.groupBox1.SuspendLayout();
			this.SuspendLayout();
			// 
			// textBoxOut
			// 
			this.textBoxOut.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.textBoxOut.Location = new System.Drawing.Point(8, 72);
			this.textBoxOut.Multiline = true;
			this.textBoxOut.Name = "textBoxOut";
			this.textBoxOut.ReadOnly = true;
			this.textBoxOut.ScrollBars = System.Windows.Forms.ScrollBars.Both;
			this.textBoxOut.Size = new System.Drawing.Size(272, 172);
			this.textBoxOut.TabIndex = 0;
			this.textBoxOut.Text = "";
			// 
			// lstPorts
			// 
			this.lstPorts.Items.AddRange(new object[] {
														  "COM1",
														  "COM2",
														  "COM3",
														  "COM4",
														  "COM5",
														  "COM6",
														  "COM7",
														  "COM8",
														  "COM9",
														  "COM10",
														  "COM11",
														  "COM12",
														  "COM13",
														  "COM14",
														  "COM15",
														  "COM16",
														  "COM17",
														  "COM18",
														  "COM19",
														  "COM20",
														  "COM21",
														  "COM22",
														  "COM23",
														  "COM24",
														  "COM25"});
			this.lstPorts.Location = new System.Drawing.Point(8, 8);
			this.lstPorts.Name = "lstPorts";
			this.lstPorts.Size = new System.Drawing.Size(64, 56);
			this.lstPorts.TabIndex = 1;
			// 
			// btnOpen
			// 
			this.btnOpen.Location = new System.Drawing.Point(80, 8);
			this.btnOpen.Name = "btnOpen";
			this.btnOpen.TabIndex = 2;
			this.btnOpen.Text = "Open";
			this.btnOpen.Click += new System.EventHandler(this.btnOpen_Click);
			// 
			// btnClose
			// 
			this.btnClose.Location = new System.Drawing.Point(80, 40);
			this.btnClose.Name = "btnClose";
			this.btnClose.TabIndex = 3;
			this.btnClose.Text = "Close";
			this.btnClose.Click += new System.EventHandler(this.btnClose_Click);
			// 
			// groupBox3
			// 
			this.groupBox3.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.groupBox3.Controls.Add(this.label12);
			this.groupBox3.Controls.Add(this.label11);
			this.groupBox3.Controls.Add(this.label10);
			this.groupBox3.Controls.Add(this.label9);
			this.groupBox3.Controls.Add(this.textBoxSatCount);
			this.groupBox3.Controls.Add(this.textBoxHeading);
			this.groupBox3.Controls.Add(this.textBoxSpeed);
			this.groupBox3.Controls.Add(this.textBoxAlt);
			this.groupBox3.Location = new System.Drawing.Point(287, 175);
			this.groupBox3.Name = "groupBox3";
			this.groupBox3.Size = new System.Drawing.Size(296, 72);
			this.groupBox3.TabIndex = 9;
			this.groupBox3.TabStop = false;
			// 
			// label12
			// 
			this.label12.Location = new System.Drawing.Point(224, 24);
			this.label12.Name = "label12";
			this.label12.Size = new System.Drawing.Size(56, 16);
			this.label12.TabIndex = 7;
			this.label12.Text = "Sat Count";
			// 
			// label11
			// 
			this.label11.Location = new System.Drawing.Point(152, 24);
			this.label11.Name = "label11";
			this.label11.Size = new System.Drawing.Size(56, 16);
			this.label11.TabIndex = 6;
			this.label11.Text = "Heading";
			// 
			// label10
			// 
			this.label10.Location = new System.Drawing.Point(80, 24);
			this.label10.Name = "label10";
			this.label10.Size = new System.Drawing.Size(48, 16);
			this.label10.TabIndex = 5;
			this.label10.Text = "Speed";
			// 
			// label9
			// 
			this.label9.Location = new System.Drawing.Point(8, 24);
			this.label9.Name = "label9";
			this.label9.Size = new System.Drawing.Size(56, 16);
			this.label9.TabIndex = 4;
			this.label9.Text = "Altitude";
			// 
			// textBoxSatCount
			// 
			this.textBoxSatCount.Location = new System.Drawing.Point(224, 40);
			this.textBoxSatCount.Name = "textBoxSatCount";
			this.textBoxSatCount.ReadOnly = true;
			this.textBoxSatCount.Size = new System.Drawing.Size(64, 20);
			this.textBoxSatCount.TabIndex = 3;
			this.textBoxSatCount.Text = "";
			// 
			// textBoxHeading
			// 
			this.textBoxHeading.Location = new System.Drawing.Point(152, 40);
			this.textBoxHeading.Name = "textBoxHeading";
			this.textBoxHeading.ReadOnly = true;
			this.textBoxHeading.Size = new System.Drawing.Size(64, 20);
			this.textBoxHeading.TabIndex = 2;
			this.textBoxHeading.Text = "";
			// 
			// textBoxSpeed
			// 
			this.textBoxSpeed.Location = new System.Drawing.Point(80, 40);
			this.textBoxSpeed.Name = "textBoxSpeed";
			this.textBoxSpeed.ReadOnly = true;
			this.textBoxSpeed.Size = new System.Drawing.Size(64, 20);
			this.textBoxSpeed.TabIndex = 1;
			this.textBoxSpeed.Text = "";
			// 
			// textBoxAlt
			// 
			this.textBoxAlt.Location = new System.Drawing.Point(8, 40);
			this.textBoxAlt.Name = "textBoxAlt";
			this.textBoxAlt.ReadOnly = true;
			this.textBoxAlt.Size = new System.Drawing.Size(64, 20);
			this.textBoxAlt.TabIndex = 0;
			this.textBoxAlt.Text = "";
			// 
			// groupBox2
			// 
			this.groupBox2.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.groupBox2.Controls.Add(this.label8);
			this.groupBox2.Controls.Add(this.label7);
			this.groupBox2.Controls.Add(this.label6);
			this.groupBox2.Controls.Add(this.label5);
			this.groupBox2.Controls.Add(this.textBoxLongDir);
			this.groupBox2.Controls.Add(this.textBoxLongSec);
			this.groupBox2.Controls.Add(this.textBoxLongMin);
			this.groupBox2.Controls.Add(this.textBoxLongDeg);
			this.groupBox2.Location = new System.Drawing.Point(287, 95);
			this.groupBox2.Name = "groupBox2";
			this.groupBox2.Size = new System.Drawing.Size(296, 72);
			this.groupBox2.TabIndex = 8;
			this.groupBox2.TabStop = false;
			this.groupBox2.Text = "Longitude";
			// 
			// label8
			// 
			this.label8.Location = new System.Drawing.Point(224, 24);
			this.label8.Name = "label8";
			this.label8.Size = new System.Drawing.Size(56, 16);
			this.label8.TabIndex = 7;
			this.label8.Text = "Direction";
			// 
			// label7
			// 
			this.label7.Location = new System.Drawing.Point(152, 24);
			this.label7.Name = "label7";
			this.label7.Size = new System.Drawing.Size(56, 16);
			this.label7.TabIndex = 6;
			this.label7.Text = "Second";
			// 
			// label6
			// 
			this.label6.Location = new System.Drawing.Point(80, 24);
			this.label6.Name = "label6";
			this.label6.Size = new System.Drawing.Size(56, 16);
			this.label6.TabIndex = 5;
			this.label6.Text = "Minute";
			// 
			// label5
			// 
			this.label5.Location = new System.Drawing.Point(8, 24);
			this.label5.Name = "label5";
			this.label5.Size = new System.Drawing.Size(56, 16);
			this.label5.TabIndex = 4;
			this.label5.Text = "Degree";
			// 
			// textBoxLongDir
			// 
			this.textBoxLongDir.Location = new System.Drawing.Point(224, 40);
			this.textBoxLongDir.Name = "textBoxLongDir";
			this.textBoxLongDir.ReadOnly = true;
			this.textBoxLongDir.Size = new System.Drawing.Size(64, 20);
			this.textBoxLongDir.TabIndex = 3;
			this.textBoxLongDir.Text = "";
			// 
			// textBoxLongSec
			// 
			this.textBoxLongSec.Location = new System.Drawing.Point(152, 40);
			this.textBoxLongSec.Name = "textBoxLongSec";
			this.textBoxLongSec.ReadOnly = true;
			this.textBoxLongSec.Size = new System.Drawing.Size(64, 20);
			this.textBoxLongSec.TabIndex = 2;
			this.textBoxLongSec.Text = "";
			// 
			// textBoxLongMin
			// 
			this.textBoxLongMin.Location = new System.Drawing.Point(80, 40);
			this.textBoxLongMin.Name = "textBoxLongMin";
			this.textBoxLongMin.ReadOnly = true;
			this.textBoxLongMin.Size = new System.Drawing.Size(64, 20);
			this.textBoxLongMin.TabIndex = 1;
			this.textBoxLongMin.Text = "";
			// 
			// textBoxLongDeg
			// 
			this.textBoxLongDeg.Location = new System.Drawing.Point(8, 40);
			this.textBoxLongDeg.Name = "textBoxLongDeg";
			this.textBoxLongDeg.ReadOnly = true;
			this.textBoxLongDeg.Size = new System.Drawing.Size(64, 20);
			this.textBoxLongDeg.TabIndex = 0;
			this.textBoxLongDeg.Text = "";
			// 
			// groupBox1
			// 
			this.groupBox1.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.groupBox1.Controls.Add(this.label4);
			this.groupBox1.Controls.Add(this.label3);
			this.groupBox1.Controls.Add(this.label2);
			this.groupBox1.Controls.Add(this.label1);
			this.groupBox1.Controls.Add(this.textBoxLatDir);
			this.groupBox1.Controls.Add(this.textBoxLatSec);
			this.groupBox1.Controls.Add(this.textBoxLatMin);
			this.groupBox1.Controls.Add(this.textBoxLatDeg);
			this.groupBox1.Location = new System.Drawing.Point(287, 15);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(296, 72);
			this.groupBox1.TabIndex = 7;
			this.groupBox1.TabStop = false;
			this.groupBox1.Text = "Latitude";
			// 
			// label4
			// 
			this.label4.Location = new System.Drawing.Point(224, 24);
			this.label4.Name = "label4";
			this.label4.Size = new System.Drawing.Size(56, 16);
			this.label4.TabIndex = 7;
			this.label4.Text = "Direction";
			// 
			// label3
			// 
			this.label3.Location = new System.Drawing.Point(152, 24);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(48, 16);
			this.label3.TabIndex = 6;
			this.label3.Text = "Second";
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(80, 24);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(100, 16);
			this.label2.TabIndex = 5;
			this.label2.Text = "Minute";
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(8, 24);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(56, 16);
			this.label1.TabIndex = 4;
			this.label1.Text = "Degree";
			// 
			// textBoxLatDir
			// 
			this.textBoxLatDir.Location = new System.Drawing.Point(224, 40);
			this.textBoxLatDir.Name = "textBoxLatDir";
			this.textBoxLatDir.ReadOnly = true;
			this.textBoxLatDir.Size = new System.Drawing.Size(64, 20);
			this.textBoxLatDir.TabIndex = 3;
			this.textBoxLatDir.Text = "";
			// 
			// textBoxLatSec
			// 
			this.textBoxLatSec.Location = new System.Drawing.Point(152, 40);
			this.textBoxLatSec.Name = "textBoxLatSec";
			this.textBoxLatSec.ReadOnly = true;
			this.textBoxLatSec.Size = new System.Drawing.Size(64, 20);
			this.textBoxLatSec.TabIndex = 2;
			this.textBoxLatSec.Text = "";
			// 
			// textBoxLatMin
			// 
			this.textBoxLatMin.Location = new System.Drawing.Point(80, 40);
			this.textBoxLatMin.Name = "textBoxLatMin";
			this.textBoxLatMin.ReadOnly = true;
			this.textBoxLatMin.Size = new System.Drawing.Size(64, 20);
			this.textBoxLatMin.TabIndex = 1;
			this.textBoxLatMin.Text = "";
			// 
			// textBoxLatDeg
			// 
			this.textBoxLatDeg.Location = new System.Drawing.Point(8, 40);
			this.textBoxLatDeg.Name = "textBoxLatDeg";
			this.textBoxLatDeg.ReadOnly = true;
			this.textBoxLatDeg.Size = new System.Drawing.Size(64, 20);
			this.textBoxLatDeg.TabIndex = 0;
			this.textBoxLatDeg.Text = "";
			// 
			// gpsReceiver
			// 
			this.gpsReceiver.BaudRate = ZylGPSReceiver.SerialBaudRate.br004800;
			this.gpsReceiver.DataWidth = ZylGPSReceiver.SerialDataWidth.dw8Bits;
			this.gpsReceiver.Delay = 100;
			this.gpsReceiver.EnableDTROnOpen = true;
			this.gpsReceiver.EnableRTSOnOpen = true;
			this.gpsReceiver.ForceCheckSum = true;
			this.gpsReceiver.HardwareFlowControl = ZylGPSReceiver.SerialHardwareFlowControl.hfNone;
			this.gpsReceiver.ParityBits = ZylGPSReceiver.SerialParityBits.pbNone;
			this.gpsReceiver.Port = ZylGPSReceiver.SerialCommPort.COM02;
			this.gpsReceiver.ReadIntervalTimeout = -1;
			this.gpsReceiver.ReadTotalTimeoutConstant = 0;
			this.gpsReceiver.ReadTotalTimeoutMultiplier = 0;
			this.gpsReceiver.SoftwareFlowControl = ZylGPSReceiver.SerialSoftwareFlowControl.sfNone;
			this.gpsReceiver.StopBits = ZylGPSReceiver.SerialStopBits.sb1Bit;
			this.gpsReceiver.WriteTotalTimeoutConstant = 1000;
			this.gpsReceiver.WriteTotalTimeoutMultiplier = 100;
			this.gpsReceiver.LongitudeChanged += new ZylGPSReceiver.PositionEventHandler(this.gpsReceiver_LongitudeChanged);
			this.gpsReceiver.HeadingChanged += new ZylGPSReceiver.ParamEventHandler(this.gpsReceiver_HeadingChanged);
			this.gpsReceiver.AltitudeChanged += new ZylGPSReceiver.ParamEventHandler(this.gpsReceiver_AltitudeChanged);
			this.gpsReceiver.Received += new ZylGPSReceiver.DataEventHandler(this.serialPort_Received);
			this.gpsReceiver.LatitudeChanged += new ZylGPSReceiver.PositionEventHandler(this.gpsReceiver_LatitudeChanged);
			this.gpsReceiver.Disconnected += new ZylGPSReceiver.ConnectionEventHandler(this.gpsReceiver_Disconnected);
			this.gpsReceiver.SatelliteReceived += new ZylGPSReceiver.SatelliteEventHandler(this.gpsReceiver_SatelliteReceived);
			this.gpsReceiver.SpeedChanged += new ZylGPSReceiver.ParamEventHandler(this.gpsReceiver_SpeedChanged);
			this.gpsReceiver.Connected += new ZylGPSReceiver.ConnectionEventHandler(this.gpsReceiver_Connected);
			// 
			// label14
			// 
			this.label14.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.label14.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label14.Location = new System.Drawing.Point(8, 278);
			this.label14.Name = "label14";
			this.label14.Size = new System.Drawing.Size(72, 23);
			this.label14.TabIndex = 17;
			this.label14.Text = "Local Time:";
			// 
			// label13
			// 
			this.label13.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.label13.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label13.Location = new System.Drawing.Point(8, 256);
			this.label13.Name = "label13";
			this.label13.Size = new System.Drawing.Size(72, 23);
			this.label13.TabIndex = 16;
			this.label13.Text = "UTC Time:";
			// 
			// lblLocalTime
			// 
			this.lblLocalTime.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.lblLocalTime.AutoSize = true;
			this.lblLocalTime.Location = new System.Drawing.Point(96, 278);
			this.lblLocalTime.Name = "lblLocalTime";
			this.lblLocalTime.Size = new System.Drawing.Size(10, 16);
			this.lblLocalTime.TabIndex = 15;
			this.lblLocalTime.Text = "?";
			// 
			// lblUTCTime
			// 
			this.lblUTCTime.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.lblUTCTime.AutoSize = true;
			this.lblUTCTime.Location = new System.Drawing.Point(96, 256);
			this.lblUTCTime.Name = "lblUTCTime";
			this.lblUTCTime.Size = new System.Drawing.Size(10, 16);
			this.lblUTCTime.TabIndex = 14;
			this.lblUTCTime.Text = "?";
			// 
			// Form1
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(592, 294);
			this.Controls.Add(this.label14);
			this.Controls.Add(this.label13);
			this.Controls.Add(this.lblLocalTime);
			this.Controls.Add(this.lblUTCTime);
			this.Controls.Add(this.groupBox3);
			this.Controls.Add(this.groupBox2);
			this.Controls.Add(this.groupBox1);
			this.Controls.Add(this.btnClose);
			this.Controls.Add(this.btnOpen);
			this.Controls.Add(this.lstPorts);
			this.Controls.Add(this.textBoxOut);
			this.Name = "Form1";
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			this.Text = "ZylGPSReceiver.NET Demo";			
			this.Closed += new System.EventHandler(this.Form1_Closed);
			this.groupBox3.ResumeLayout(false);
			this.groupBox2.ResumeLayout(false);
			this.groupBox1.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}

		private void btnOpen_Click(object sender, System.EventArgs e)
		{			
			gpsReceiver.Port = (SerialCommPort)(lstPorts.SelectedIndex + 1); 
			gpsReceiver.Delay = 1000;
			gpsReceiver.Open();
		}

		private void btnClose_Click(object sender, System.EventArgs e)
		{
			gpsReceiver.Close();
		}

		private void Form1_Closed(object sender, System.EventArgs e)
		{
			if (gpsReceiver != null)
				gpsReceiver.Close();
		}

        private void Set_textBoxOut(string text)
        {
            // InvokeRequired required compares the thread ID of the
            // calling thread to the thread ID of the creating thread.
            // If these threads are different, it returns true.
            if (this.textBoxOut.InvokeRequired)
            {
                SetTextCallback d = new SetTextCallback(Set_textBoxOut);
                this.Invoke(d, new object[] { text });
            }
            else
            {
                this.textBoxOut.Text = text;
                this.textBoxOut.SelectionStart = textBoxOut.Text.Length;
                this.textBoxOut.SelectionLength = 0;
                this.textBoxOut.ScrollToCaret();
            }
        }

        private void Set_lblUTCTime(string text)
        {
            // InvokeRequired required compares the thread ID of the
            // calling thread to the thread ID of the creating thread.
            // If these threads are different, it returns true.
            if (this.lblUTCTime.InvokeRequired)
            {
                SetTextCallback d = new SetTextCallback(Set_lblUTCTime);
                this.Invoke(d, new object[] { text });
            }
            else
            {
                this.lblUTCTime.Text = text;                
            }
        }

        private void Set_lblLocalTime(string text)
        {
            // InvokeRequired required compares the thread ID of the
            // calling thread to the thread ID of the creating thread.
            // If these threads are different, it returns true.
            if (this.lblLocalTime.InvokeRequired)
            {
                SetTextCallback d = new SetTextCallback(Set_lblLocalTime);
                this.Invoke(d, new object[] { text });
            }
            else
            {
                this.lblLocalTime.Text = text;
            }
        }

        private void Set_textBoxLatDeg(string text)
        {
            // InvokeRequired required compares the thread ID of the
            // calling thread to the thread ID of the creating thread.
            // If these threads are different, it returns true.
            if (this.textBoxLatDeg.InvokeRequired)
            {
                SetTextCallback d = new SetTextCallback(Set_textBoxLatDeg);
                this.Invoke(d, new object[] { text });
            }
            else
            {
                this.textBoxLatDeg.Text = text;
            }
        }

        private void Set_textBoxLatMin(string text)
        {
            // InvokeRequired required compares the thread ID of the
            // calling thread to the thread ID of the creating thread.
            // If these threads are different, it returns true.
            if (this.textBoxLatMin.InvokeRequired)
            {
                SetTextCallback d = new SetTextCallback(Set_textBoxLatMin);
                this.Invoke(d, new object[] { text });
            }
            else
            {
                this.textBoxLatMin.Text = text;
            }
        }

        private void Set_textBoxLatSec(string text)
        {
            // InvokeRequired required compares the thread ID of the
            // calling thread to the thread ID of the creating thread.
            // If these threads are different, it returns true.
            if (this.textBoxLatSec.InvokeRequired)
            {
                SetTextCallback d = new SetTextCallback(Set_textBoxLatSec);
                this.Invoke(d, new object[] { text });
            }
            else
            {
                this.textBoxLatSec.Text = text;
            }
        }

        private void Set_textBoxLatDir(string text)
        {
            // InvokeRequired required compares the thread ID of the
            // calling thread to the thread ID of the creating thread.
            // If these threads are different, it returns true.
            if (this.textBoxLatDir.InvokeRequired)
            {
                SetTextCallback d = new SetTextCallback(Set_textBoxLatDir);
                this.Invoke(d, new object[] { text });
            }
            else
            {
                this.textBoxLatDir.Text = text;
            }
        }

        private void Set_textBoxLongDeg(string text)
        {
            // InvokeRequired required compares the thread ID of the
            // calling thread to the thread ID of the creating thread.
            // If these threads are different, it returns true.
            if (this.textBoxLongDeg.InvokeRequired)
            {
                SetTextCallback d = new SetTextCallback(Set_textBoxLongDeg);
                this.Invoke(d, new object[] { text });
            }
            else
            {
                this.textBoxLongDeg.Text = text;
            }
        }

        private void Set_textBoxLongMin(string text)
        {
            // InvokeRequired required compares the thread ID of the
            // calling thread to the thread ID of the creating thread.
            // If these threads are different, it returns true.
            if (this.textBoxLongMin.InvokeRequired)
            {
                SetTextCallback d = new SetTextCallback(Set_textBoxLongMin);
                this.Invoke(d, new object[] { text });
            }
            else
            {
                this.textBoxLongMin.Text = text;
            }
        }

        private void Set_textBoxLongSec(string text)
        {
            // InvokeRequired required compares the thread ID of the
            // calling thread to the thread ID of the creating thread.
            // If these threads are different, it returns true.
            if (this.textBoxLongSec.InvokeRequired)
            {
                SetTextCallback d = new SetTextCallback(Set_textBoxLongSec);
                this.Invoke(d, new object[] { text });
            }
            else
            {
                this.textBoxLongSec.Text = text;
            }
        }

        private void Set_textBoxLongDir(string text)
        {
            // InvokeRequired required compares the thread ID of the
            // calling thread to the thread ID of the creating thread.
            // If these threads are different, it returns true.
            if (this.textBoxLongDir.InvokeRequired)
            {
                SetTextCallback d = new SetTextCallback(Set_textBoxLongDir);
                this.Invoke(d, new object[] { text });
            }
            else
            {
                this.textBoxLongDir.Text = text;
            }
        }

        private void Set_textBoxAlt(string text)
        {
            // InvokeRequired required compares the thread ID of the
            // calling thread to the thread ID of the creating thread.
            // If these threads are different, it returns true.
            if (this.textBoxAlt.InvokeRequired)
            {
                SetTextCallback d = new SetTextCallback(Set_textBoxAlt);
                this.Invoke(d, new object[] { text });
            }
            else
            {
                this.textBoxAlt.Text = text;
            }
        }

        private void Set_textBoxSpeed(string text)
        {
            // InvokeRequired required compares the thread ID of the
            // calling thread to the thread ID of the creating thread.
            // If these threads are different, it returns true.
            if (this.textBoxSpeed.InvokeRequired)
            {
                SetTextCallback d = new SetTextCallback(Set_textBoxSpeed);
                this.Invoke(d, new object[] { text });
            }
            else
            {
                this.textBoxSpeed.Text = text;
            }
        }

        private void Set_textBoxHeading(string text)
        {
            // InvokeRequired required compares the thread ID of the
            // calling thread to the thread ID of the creating thread.
            // If these threads are different, it returns true.
            if (this.textBoxHeading.InvokeRequired)
            {
                SetTextCallback d = new SetTextCallback(Set_textBoxHeading);
                this.Invoke(d, new object[] { text });
            }
            else
            {
                this.textBoxHeading.Text = text;
            }
        }

        private void Set_textBoxSatCount(string text)
        {
            // InvokeRequired required compares the thread ID of the
            // calling thread to the thread ID of the creating thread.
            // If these threads are different, it returns true.
            if (this.textBoxSatCount.InvokeRequired)
            {
                SetTextCallback d = new SetTextCallback(Set_textBoxSatCount);
                this.Invoke(d, new object[] { text });
            }
            else
            {
                this.textBoxSatCount.Text = text;
            }
        }

		private void serialPort_Received(object sender, ZylGPSReceiver.DataEventArgs e)
		{
			Set_textBoxOut(textBoxOut.Text + GPSReceiver.ASCIIByteArrayToString(e.Buffer) + Environment.NewLine);			

			Set_lblUTCTime(gpsReceiver.Position.GetUTCDateTime().ToString());
			Set_lblLocalTime(gpsReceiver.Position.GetLocalDateTime().ToString());

			Set_textBoxLatDeg(gpsReceiver.Position.Latitude_Degree.ToString());
			Set_textBoxLatMin(gpsReceiver.Position.Latitude_Minute.ToString());
			Set_textBoxLatSec(gpsReceiver.Position.Latitude_Second.ToString());
			if (gpsReceiver.Position.Latitude_Direction == GPSPosition.CardinalPoint.cpNorth)
				Set_textBoxLatDir("North");
			else
				Set_textBoxLatDir("South");

			Set_textBoxLongDeg(gpsReceiver.Position.Longitude_Degree.ToString());
            Set_textBoxLongMin(gpsReceiver.Position.Longitude_Minute.ToString());
            Set_textBoxLongSec(gpsReceiver.Position.Longitude_Second.ToString());
			if (gpsReceiver.Position.Longitude_Direction == GPSPosition.CardinalPoint.cpEast)
                Set_textBoxLongDir("East");
			else
                Set_textBoxLongDir("West");

            Set_textBoxAlt(gpsReceiver.Position.Altitude.ToString());
            Set_textBoxSpeed(gpsReceiver.Position.Speed_KMH.ToString());
            Set_textBoxHeading(gpsReceiver.Position.Heading.ToString());
            Set_textBoxSatCount(gpsReceiver.Position.Satellite_Count.ToString());
        }

		private void gpsReceiver_SatelliteReceived(object sender, ZylGPSReceiver.SatelliteEventArgs e)
		{
			Set_textBoxOut(textBoxOut.Text + "Satellite received: " + e.PseudoRandomCode + "/" + e.Azimuth + "/" + 
				e.Elevation + "/" + e.SignalToNoiseRatio + Environment.NewLine);			
		}

		private void gpsReceiver_LatitudeChanged(object sender, ZylGPSReceiver.PositionEventArgs e)
		{
			Set_textBoxOut(textBoxOut.Text + "Latitude changed: " + 
				GPSPosition.DMSToDecimalDegrees(e.Degree, e.Minute, e.Second, 
				e.Direction).ToString() + Environment.NewLine);			
		}

		private void gpsReceiver_LongitudeChanged(object sender, ZylGPSReceiver.PositionEventArgs e)
		{
			Set_textBoxOut(textBoxOut.Text + "Longitude changed: " + 
				GPSPosition.DMSToDecimalDegrees(e.Degree, e.Minute, e.Second, 
				e.Direction).ToString() + Environment.NewLine);			
		}

		private void gpsReceiver_AltitudeChanged(object sender, ZylGPSReceiver.ParamEventArgs e)
		{
			Set_textBoxOut(textBoxOut.Text + "Altitude changed: " + e.Value.ToString() + " m" + Environment.NewLine);		
		}

		private void gpsReceiver_Connected(object sender, ZylGPSReceiver.ConnectionEventArgs e)
		{
			Set_textBoxOut(textBoxOut.Text + "Connected to: " + e.Port.ToString() + Environment.NewLine);			
		}

		private void gpsReceiver_Disconnected(object sender, ZylGPSReceiver.ConnectionEventArgs e)
		{
			Set_textBoxOut(textBoxOut.Text + "Disconnected from: " + e.Port.ToString() + Environment.NewLine);			
		}

		private void gpsReceiver_HeadingChanged(object sender, ZylGPSReceiver.ParamEventArgs e)
		{
			Set_textBoxOut(textBoxOut.Text + "Heading changed: " + e.Value.ToString() + " degrees" + Environment.NewLine);		
		}

		private void gpsReceiver_SpeedChanged(object sender, ZylGPSReceiver.ParamEventArgs e)
		{
			Set_textBoxOut(textBoxOut.Text + "Speed changed: " + e.Value.ToString() + " km/h" + Environment.NewLine);		
		}
	}
}
